/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.mayaqq.estrogen.client.registry.EstrogenRenderType;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.DreamBlockRenderer;
import dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture.advanced.Goober;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_6008;

public class DynamicDreamTexture {
    public static final DynamicDreamTexture INSTANCE = new DynamicDreamTexture();
    public static boolean enableAnimation = true;
    private static final AtomicBoolean shouldAnimate = new AtomicBoolean();
    private final List<Goober> goobers = new ObjectArrayList();
    private class_1043 texture;
    private class_2960 texID;
    private class_1921 renderType;
    private long seed = 80085L;
    private int animationTick = 0;
    private boolean init = false;

    public void prepare() {
        if (this.init) {
            return;
        }
        this.texture = new class_1043(128, 128, false);
        this.texID = class_310.method_1551().method_1531().method_4617("dreamy", this.texture);
        this.renderType = EstrogenRenderType.DREAM_BLOCK.apply(this.texID);
        this.draw();
        this.init = true;
    }

    private void _release() {
        if (!this.init) {
            return;
        }
        class_310.method_1551().method_1531().method_4615(this.texID);
        this.texture = null;
        this.texID = null;
        this.renderType = null;
        this.init = false;
    }

    public void release() {
        if (RenderSystem.isOnRenderThread()) {
            this._release();
        } else {
            RenderSystem.recordRenderCall(this::_release);
        }
    }

    public class_1921 getRenderType() {
        return this.renderType;
    }

    public void changeSeed(long seed) {
        this.seed = seed;
        this.generateGoobers();
        this.redraw();
    }

    public void generateGoobers() {
        class_5819 random = class_5819.method_43049((long)this.seed);
        if (!this.goobers.isEmpty()) {
            this.goobers.clear();
        }
        int count = random.method_39332(50, 60);
        int attempts = 16;
        while (count > 0) {
            boolean canPlace = true;
            int posX = random.method_43051(4, 124);
            int posY = random.method_43051(4, 124);
            for (Goober goob : this.goobers) {
                if (!goob.tooClose(posX, posY)) continue;
                canPlace = false;
                break;
            }
            if (canPlace) {
                Goober.Style style = Goober.Style.weighted(random);
                Goober.Color color = Goober.Color.values()[random.method_39332(0, 5)];
                int animTick = style.hasAnimation() ? random.method_39332(0, 10) : 0;
                int beginFrame = random.method_43051(0, style.frameCount());
                int transparency = Goober.TRANSPARENCY.method_34992(random).map(class_6008.class_6010::method_34983).orElse(0);
                Goober goober = new Goober(posX, posY, color, style, animTick, beginFrame, transparency);
                this.goobers.add(goober);
                --count;
                continue;
            }
            if (--attempts != 0) continue;
            --count;
            attempts = 16;
        }
    }

    protected void draw() {
        class_1011 pixels = this.texture.method_4525();
        pixels.method_51596(i -> -16777216);
        for (Goober goober : this.goobers) {
            goober.draw(pixels);
        }
        this.texture.method_4524();
    }

    public void tick() {
        ++this.animationTick;
        if (this.animationTick == 10) {
            this.animationTick = 0;
        }
        boolean redraw = false;
        for (Goober goober : this.goobers) {
            if (!goober.tickAnimation(this.animationTick)) continue;
            redraw = true;
        }
        if (this.shouldAnimate() && redraw) {
            this.redraw();
        }
    }

    public void redraw() {
        if (!this.init) {
            return;
        }
        if (RenderSystem.isOnRenderThread()) {
            this.draw();
        } else {
            RenderSystem.recordRenderCall(this::draw);
        }
    }

    private boolean shouldAnimate() {
        return enableAnimation && DreamBlockRenderer.useAdvancedRenderer() && shouldAnimate.get();
    }

    public static void setActive() {
        shouldAnimate.set(true);
    }

    public static void resetActive() {
        shouldAnimate.set(false);
    }
}

